﻿WITH message (id_message,message,liste_mot_cle)
AS   (VALUES (1,'corps mess1','sql,déclencheur,table'),(2,'corps mess2','sql,performance'),
             (3,'corps mess3','déclancheur'),(4,'corps mess4','vue,table')),
     recherche (id_recherche,liste_recherche) 
AS   (VALUES (1,'sql,performance'),(2,'déclencheur'),(3,'table,performance,vue')),
     decomposition_message (id_message,message,liste_mot_cle,mot_cle)
AS   (SELECT id_message,message,liste_mot_cle,
            regexp_split_to_table(message.liste_mot_cle,',+') AS mot_cle
            -- Coupe les chaines de caractère en utilisant le séparateur virgule.
            -- Chaque mot est généré sur une ligne (fonction ensembliste)
     FROM   message), 
     decomposition_recherche (id_recherche,liste_recherche,recherche)
AS   (SELECT id_recherche,liste_recherche,
             regexp_split_to_table(recherche.liste_recherche,',+') AS recherche      
      FROM   recherche)
SELECT id_recherche,liste_recherche,id_message,message,liste_mot_cle,COUNT(*) AS "score"
FROM   decomposition_message 
       JOIN decomposition_recherche ON mot_cle=recherche 
GROUP  BY id_recherche,liste_recherche,id_message,message,liste_mot_cle
ORDER  BY 1,5 DESC;